/**
 ******************************************************************************
 *                                                                            *
 * @file        startup_MG32_GCC.s                                        *
 *                                                                            *
 * @brief       MG32 Device vector table for GCC                          *
 *                                                                            *
 * @par         Project                                                       *
 *              MG32                                                      *
 * @version     V0.1 (Interrupt Table Date : 2022_0923)                       *
 * @date        2022/09/23 10:00 (Startup File Generated Date)                *
 * @author      StartupGen V0.1                                               *
 * @note        Copyright (c) 2021 MegaWin Technology Co., Ltd.               *
 *              All rights reserved.                                          *
 *                                                                            *
 * Important!   This file is generated by code generator. Do not edit!        *
 *                                                                            *
 ******************************************************************************
 */

  .syntax unified
  .cpu cortex-m0
  .fpu softvfp
  .thumb

.global g_pfnVectors
.global Default_Handler

/* start address for the initialization values of the .data section.
defined in linker script */
.word _sidata
/* start address for the .data section. defined in linker script */
.word _sdata
/* end address for the .data section. defined in linker script */
.word _edata
/* start address for the .bss section. defined in linker script */
.word _sbss
/* end address for the .bss section. defined in linker script */
.word _ebss

  .section .text.Reset_Handler
  .weak Reset_Handler
  .type Reset_Handler, %function
Reset_Handler:
  ldr   r0, =_estack
  mov   sp, r0          /* set stack pointer */

/* Copy the data segment initializers from flash to SRAM */
  ldr r0, =_sdata
  ldr r1, =_edata
  ldr r2, =_sidata
  movs r3, #0
  b LoopCopyDataInit

CopyDataInit:
  ldr r4, [r2, r3]
  str r4, [r0, r3]
  adds r3, r3, #4

LoopCopyDataInit:
  adds r4, r0, r3
  cmp r4, r1
  bcc CopyDataInit

/* Zero fill the bss segment. */
  ldr r2, =_sbss
  ldr r4, =_ebss
  movs r3, #0
  b LoopFillZerobss

FillZerobss:
  str  r3, [r2]
  adds r2, r2, #4

LoopFillZerobss:
  cmp r2, r4
  bcc FillZerobss

/*
  Call the clock system intitialization function.
  Please reference system_MG32.c file.
 */
  bl  SystemInit
/* Call the application's entry point.*/
  bl main

LoopForever:
    b LoopForever


.size Reset_Handler, .-Reset_Handler

/**
 * @brief  This is the code that gets called when the processor receives an
 *         unexpected interrupt.  This simply enters an infinite loop, preserving
 *         the system state for examination by a debugger.
 *
 * @param  None
 * @retval : None
*/
    .section .text.Default_Handler,"ax",%progbits
Default_Handler:
Infinite_Loop:
  b Infinite_Loop
  .size Default_Handler, .-Default_Handler
/******************************************************************************
*
* The minimal vector table for a Cortex M0.  Note that the proper constructs
* must be placed on this to ensure that it ends up at physical address
* 0x0000.0000.
*
******************************************************************************/
   .section .isr_vector,"a",%progbits
  .type g_pfnVectors, %object
  .size g_pfnVectors, .-g_pfnVectors


g_pfnVectors:
  .word  _estack
  .word  Reset_Handler                     /* Reset Handler                */
  .word  NMI_Handler					   /* NMI Handler                  */
  .word  HardFault_Handler				   /* HardFault Handler            */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  SVC_Handler					   /* SVCall Handler               */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  PendSV_Handler					   /* PendSV Handler               */
  .word  SysTick_Handler				   /* SysTick Handler              */

  /* External interrupts                                                   */
  .word  WWDT_IRQHandler				   /* Window Watchdog              */
  .word  SYS_IRQHandler  				   /* System global Interrupt      */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  EXINT0_IRQHandler                 /* EXIC EXINT0                  */
  .word  EXINT1_IRQHandler                 /* EXIC EXINT1                  */
  .word  EXINT2_IRQHandler                 /* EXIC EXINT2                  */
  .word  EXINT3_IRQHandler                 /* EXIC EXINT3                  */
  .word  COMP_IRQHandler                   /* Analog Comparators global Interrupt */
  .word  DMA_IRQHandler                    /* DMA all channel global Interrupt */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  ADC_IRQHandler                    /* ADC global Interrupt         */
  .word  DAC_IRQHandler                    /* DAC global Interrupt         */
  .word  TM0x_IRQHandler                   /* Timer TM0x global Interrupt  */
  .word  TM10_IRQHandler                   /* Timer TM10                   */
  .word  TM1x_IRQHandler                   /* Timer TM1x global Interrupt  */
  .word  TM20_IRQHandler                   /* Timer TM20                   */
  .word  TM2x_IRQHandler                   /* Timer TM2x global Interrupt  */
  .word  TM3x_IRQHandler                   /* Timer TM3x global Interrupt  */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  URT0_IRQHandler                   /* UART URT0                    */
  .word  URT123_IRQHandler                 /* UART URT1/2/3 global Interrupt */
  .word  URT4x_IRQHandler                  /* UART URT4/5/6/7/.. global Interrupt */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  SPI0_IRQHandler                   /* SPI0                         */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  0xFFFFFFFF					       /* Reserved                     */
  .word  I2C0_IRQHandler                   /* I2C0                         */
  .word  I2Cx_IRQHandler                   /* I2Cx global Interrupt        */
  .word  USB_IRQHandler                    /* USB                          */
  .word  APX_IRQHandler                    /* APX                          */


/*******************************************************************************
*
* Provide weak aliases for each Exception handler to the Default_Handler.
* As they are weak aliases, any function with the same name will override
* this definition.
*
*******************************************************************************/

  .weak      NMI_Handler
  .thumb_set NMI_Handler,Default_Handler

  .weak      HardFault_Handler
  .thumb_set HardFault_Handler,Default_Handler

  .weak      SVC_Handler
  .thumb_set SVC_Handler,Default_Handler

  .weak      PendSV_Handler
  .thumb_set PendSV_Handler,Default_Handler

  .weak      SysTick_Handler
  .thumb_set SysTick_Handler,Default_Handler

  /* External interrupt                        							   */
  .weak      WWDT_IRQHandler
  .thumb_set WWDT_IRQHandler,Default_Handler

  .weak      SYS_IRQHandler
  .thumb_set SYS_IRQHandler,Default_Handler

  .weak      EXINT0_IRQHandler
  .thumb_set EXINT0_IRQHandler,Default_Handler

  .weak      EXINT1_IRQHandler
  .thumb_set EXINT1_IRQHandler,Default_Handler

  .weak      EXINT2_IRQHandler
  .thumb_set EXINT2_IRQHandler,Default_Handler

  .weak      EXINT3_IRQHandler
  .thumb_set EXINT3_IRQHandler,Default_Handler

  .weak      COMP_IRQHandler
  .thumb_set COMP_IRQHandler,Default_Handler

  .weak      DMA_IRQHandler
  .thumb_set DMA_IRQHandler,Default_Handler

  .weak      ADC_IRQHandler
  .thumb_set ADC_IRQHandler,Default_Handler

  .weak      DAC_IRQHandler
  .thumb_set DAC_IRQHandler,Default_Handler

  .weak      TM0x_IRQHandler
  .thumb_set TM0x_IRQHandler,Default_Handler

  .weak      TM10_IRQHandler
  .thumb_set TM10_IRQHandler,Default_Handler

  .weak      TM1x_IRQHandler
  .thumb_set TM1x_IRQHandler,Default_Handler

  .weak      TM20_IRQHandler
  .thumb_set TM20_IRQHandler,Default_Handler

  .weak      TM2x_IRQHandler
  .thumb_set TM2x_IRQHandler,Default_Handler

  .weak      TM3x_IRQHandler
  .thumb_set TM3x_IRQHandler,Default_Handler

  .weak      URT0_IRQHandler
  .thumb_set URT0_IRQHandler,Default_Handler

  .weak      URT123_IRQHandler
  .thumb_set URT123_IRQHandler,Default_Handler

  .weak      URT4x_IRQHandler
  .thumb_set URT4x_IRQHandler,Default_Handler

  .weak      SPI0_IRQHandler
  .thumb_set SPI0_IRQHandler,Default_Handler

  .weak      I2C0_IRQHandler
  .thumb_set I2C0_IRQHandler,Default_Handler

  .weak      I2Cx_IRQHandler
  .thumb_set I2Cx_IRQHandler,Default_Handler

  .weak      USB_IRQHandler
  .thumb_set USB_IRQHandler,Default_Handler

  .weak      APX_IRQHandler
  .thumb_set APX_IRQHandler,Default_Handler

/************************ End of file ************************/

